/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.metrics;

import io.opentelemetry.sdk.metrics.Aggregation;
import java.util.Arrays;

public enum HistogramEnum {
    SEND_SUCCESS_COST_TIME("rocketmq_send_cost_time", Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 5.0, 10.0, 20.0, 50.0, 200.0, 500.0))),
    DELIVERY_LATENCY("rocketmq_delivery_latency", Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 5.0, 10.0, 20.0, 50.0, 200.0, 500.0))),
    AWAIT_TIME("rocketmq_await_time", Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 5.0, 20.0, 100.0, 1000.0, 5000.0, 10000.0))),
    PROCESS_TIME("rocketmq_process_time", Aggregation.explicitBucketHistogram(Arrays.asList(1.0, 5.0, 10.0, 100.0, 1000.0, 10000.0, 60000.0)));

    private final String name;
    private final Aggregation bucket;

    private HistogramEnum(String name, Aggregation bucket) {
        this.name = name;
        this.bucket = bucket;
    }

    public String getName() {
        return this.name;
    }

    public Aggregation getBucket() {
        return this.bucket;
    }
}

