/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.inspector.internal;

import com.netflix.config.DynamicProperty;
import io.swagger.annotations.ApiResponse;
import io.swagger.models.Swagger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.common.rest.resource.ClassPathStaticResourceHandler;
import org.apache.servicecomb.common.rest.resource.StaticResourceHandler;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.priority.PriorityProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyManager;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.foundation.common.part.AbstractPart;
import org.apache.servicecomb.foundation.common.part.InputStreamPart;
import org.apache.servicecomb.inspector.internal.InspectorConfig;
import org.apache.servicecomb.inspector.internal.model.DynamicPropertyView;
import org.apache.servicecomb.inspector.internal.model.PriorityPropertyView;
import org.apache.servicecomb.inspector.internal.swagger.SchemaFormat;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/inspector")
public class InspectorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectorImpl.class);
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private final SCBEngine scbEngine;
    private InspectorConfig inspectorConfig;
    private Map<String, String> schemas;
    private StaticResourceHandler resourceHandler = new ClassPathStaticResourceHandler();
    private PriorityPropertyManager priorityPropertyManager;

    public InspectorImpl(SCBEngine scbEngine, InspectorConfig inspectorConfig, Map<String, String> schemas) {
        this.scbEngine = scbEngine;
        this.inspectorConfig = inspectorConfig;
        this.schemas = new LinkedHashMap<String, String>(schemas);
        this.correctBasePathForOnlineTest();
    }

    public SCBEngine getScbEngine() {
        return this.scbEngine;
    }

    public InspectorConfig getInspectorConfig() {
        return this.inspectorConfig;
    }

    private void correctBasePathForOnlineTest() {
        Transport restTransport = this.scbEngine.getTransportManager().findTransport("rest");
        if (restTransport == null || !restTransport.getClass().getName().equals("org.apache.servicecomb.transport.rest.servlet.ServletRestTransport")) {
            return;
        }
        String urlPrefix = System.getProperty("urlPrefix");
        if (StringUtils.isEmpty((CharSequence)urlPrefix)) {
            return;
        }
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            Swagger swagger = SwaggerUtils.parseSwagger((String)entry.getValue());
            if (swagger.getBasePath().startsWith(urlPrefix)) continue;
            swagger.setBasePath(urlPrefix + swagger.getBasePath());
            entry.setValue(SwaggerUtils.swaggerToString((Swagger)swagger));
        }
    }

    public void setPriorityPropertyManager(PriorityPropertyManager priorityPropertyManager) {
        this.priorityPropertyManager = priorityPropertyManager;
    }

    @Path(value="/schemas")
    @GET
    public Collection<String> getSchemaIds() {
        return this.schemas.keySet();
    }

    @Path(value="/download/schemas")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response downloadSchemas(@QueryParam(value="format") SchemaFormat format) {
        if (format == null) {
            format = SchemaFormat.SWAGGER;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(os);){
            for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey() + format.getSuffix()));
                String content = entry.getValue();
                zos.write(content.getBytes(StandardCharsets.UTF_8));
                zos.closeEntry();
            }
        }
        catch (Throwable e) {
            String msg = "failed to create schemas zip file, format=" + (Object)((Object)format) + ".";
            LOGGER.error(msg, e);
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, msg));
        }
        AbstractPart part = new InputStreamPart(null, (InputStream)new ByteArrayInputStream(os.toByteArray())).setSubmittedFileName(RegistryUtils.getMicroservice().getServiceName() + format.getSuffix() + ".zip");
        return Response.ok((Object)part);
    }

    @Path(value="/schemas/{schemaId}")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response getSchemaContentById(@PathParam(value="schemaId") String schemaId, @QueryParam(value="format") SchemaFormat format, @QueryParam(value="download") boolean download) {
        String swaggerContent = this.schemas.get(schemaId);
        if (swaggerContent == null) {
            return Response.failResp((InvocationException)new InvocationException((Response.StatusType)Response.Status.NOT_FOUND, Response.Status.NOT_FOUND.getReasonPhrase()));
        }
        if (format == null) {
            format = SchemaFormat.SWAGGER;
        }
        byte[] bytes = swaggerContent.getBytes(StandardCharsets.UTF_8);
        AbstractPart part = new InputStreamPart(null, (InputStream)new ByteArrayInputStream(bytes)).setSubmittedFileName(schemaId + format.getSuffix());
        Response response = Response.ok((Object)part);
        if (!download) {
            response.setHeader("Content-Disposition", "inline");
        }
        response.setHeader("Content-Type", "text/html");
        return response;
    }

    @Path(value="/{path : .+}")
    @GET
    @ApiResponse(code=200, message="", response=File.class)
    public Response getStaticResource(@PathParam(value="path") String path) {
        return this.resourceHandler.handle(path);
    }

    @Path(value="/dynamicProperties")
    @GET
    public List<DynamicPropertyView> dynamicProperties() {
        ArrayList<DynamicPropertyView> views = new ArrayList<DynamicPropertyView>();
        for (DynamicProperty property : ConfigUtil.getAllDynamicProperties().values()) {
            views.add(this.createDynamicPropertyView(property));
        }
        views.sort(Comparator.comparing(DynamicPropertyView::getCallbackCount).thenComparing(DynamicPropertyView::getChangedTime).reversed().thenComparing(DynamicPropertyView::getKey));
        return views;
    }

    private DynamicPropertyView createDynamicPropertyView(DynamicProperty property) {
        DynamicPropertyView view = new DynamicPropertyView();
        view.setKey(property.getName());
        view.setValue(property.getString());
        if (property.getChangedTimestamp() != 0L) {
            LocalDateTime localDatetime = LocalDateTime.ofInstant(Instant.ofEpochMilli(property.getChangedTimestamp()), ZoneId.systemDefault());
            view.setChangedTime(localDatetime.format(FORMATTER));
        }
        view.setCallbackCount(ConfigUtil.getCallbacks((DynamicProperty)property).size());
        return view;
    }

    @Path(value="/priorityProperties")
    @GET
    public List<PriorityPropertyView> priorityProperties() {
        ArrayList<PriorityPropertyView> views = new ArrayList<PriorityPropertyView>();
        this.priorityPropertyManager.getConfigObjectMap().values().stream().flatMap(Collection::stream).forEach(p -> views.add(this.createPriorityPropertyView((PriorityProperty<?>)p)));
        this.priorityPropertyManager.getPriorityPropertyMap().values().forEach(p -> views.add(this.createPriorityPropertyView((PriorityProperty<?>)p)));
        return views;
    }

    private PriorityPropertyView createPriorityPropertyView(PriorityProperty<?> priorityProperty) {
        PriorityPropertyView view = new PriorityPropertyView();
        view.setDynamicProperties(new ArrayList<DynamicPropertyView>());
        for (DynamicProperty property : priorityProperty.getProperties()) {
            view.getDynamicProperties().add(this.createDynamicPropertyView(property));
        }
        view.setDefaultValue(String.valueOf(priorityProperty.getDefaultValue()));
        view.setValue(String.valueOf(priorityProperty.getValue()));
        return view;
    }
}

