/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.LongGetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class SInt64WriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Long.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new SInt64PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Long.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new SInt64Schema(protoField, propertyDescriptor);
        }
        return new SInt64DynamicSchema(protoField, propertyDescriptor);
    }

    private static class SInt64PrimitiveSchema<T>
    extends SInt64DynamicSchema<T> {
        private final LongGetter<T> primitiveGetter;

        public SInt64PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (LongGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            long value = this.primitiveGetter.get(message);
            output.writeScalarSInt64(this.tag, this.tagSize, value);
        }
    }

    private static class SInt64Schema<T>
    extends SInt64DynamicSchema<T> {
        protected final Getter<T, Long> getter;

        public SInt64Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Long value = (Long)this.getter.get(message);
            if (value != null) {
                output.writeScalarSInt64(this.tag, this.tagSize, value);
            }
        }
    }

    private static class SInt64DynamicSchema<T>
    extends FieldSchema<T> {
        public SInt64DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarSInt64(this.tag, this.tagSize, ((Number)value).longValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                long parsedValue = Long.parseLong(((String[])value)[0], 10);
                output.writeScalarSInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                long parsedValue = Long.parseLong((String)value, 10);
                output.writeScalarSInt64(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

