/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.lang.reflect.Constructor;
import org.apache.openjpa.enhance.DynamicStorage;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.openjpa.util.asm.EnhancementClassLoader;
import org.apache.openjpa.util.asm.EnhancementProject;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.AbstractInsnNode;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.FieldNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.JumpInsnNode;
import org.apache.xbean.asm9.tree.LabelNode;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.TableSwitchInsnNode;
import org.apache.xbean.asm9.tree.TypeInsnNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

public class DynamicStorageGenerator {
    private static final String PREFIX = "openjpastorage$";
    protected static final int POLICY_EXCEPTION = 0;
    protected static final int POLICY_EMPTY = 1;
    protected static final int POLICY_SILENT = 2;
    private static final Class[][] WRAPPERS = new Class[][]{{Boolean.TYPE, Boolean.class}, {Byte.TYPE, Byte.class}, {Character.TYPE, Character.class}, {Integer.TYPE, Integer.class}, {Short.TYPE, Short.class}, {Long.TYPE, Long.class}, {Float.TYPE, Float.class}, {Double.TYPE, Double.class}};
    private static final int[] TYPES = new int[]{0, 1, 2, 5, 7, 6, 4, 3, 8};
    private final EnhancementProject _project = new EnhancementProject();
    private final EnhancementClassLoader _loader = new EnhancementClassLoader(this._project, DynamicStorage.class.getClassLoader());

    public DynamicStorage generateStorage(int[] types, Object obj) {
        if (obj == null) {
            return null;
        }
        String name = this.getClassName(obj);
        ClassNodeTracker bc = this._project.loadClass(name);
        this.declareClasses(bc);
        this.addDefaultConstructor(bc);
        int objectCount = this.declareFields(types, bc);
        this.addFactoryMethod(bc);
        this.addFieldCount(bc, types, objectCount);
        this.addSetMethods(bc, types, objectCount);
        this.addGetMethods(bc, types);
        this.addInitialize(bc, objectCount);
        this.decorate(obj, bc, types);
        return this.createFactory(bc);
    }

    private void addDefaultConstructor(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        boolean hasDefaultCt = classNode.methods.stream().anyMatch(m -> m.name.equals("<init>") && m.desc.equals("()V"));
        if (!hasDefaultCt) {
            MethodNode ctNode = new MethodNode(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
            ctNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            ctNode.instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.superName, "<init>", "()V"));
            ctNode.instructions.add((AbstractInsnNode)new InsnNode(177));
            classNode.methods.add(ctNode);
        }
    }

    protected String getClassName(Object obj) {
        return PREFIX + obj.toString();
    }

    protected int getFieldAccess() {
        return 2;
    }

    protected String getFieldName(int index) {
        return "field" + index;
    }

    protected int getCreateFieldMethods(int type) {
        return 0;
    }

    protected void decorate(Object obj, ClassNodeTracker cls, int[] types) {
    }

    protected DynamicStorage createFactory(ClassNodeTracker bc) {
        try {
            Class<?> cls = Class.forName(bc.getClassNode().name.replace("/", "."), false, this._loader);
            Constructor<?> cons = cls.getConstructor(null);
            DynamicStorage data = (DynamicStorage)cons.newInstance(null);
            this._project.clear();
            return data;
        }
        catch (Throwable t) {
            throw new InternalException("cons-access", t).setFatal(true);
        }
    }

    protected void declareClasses(ClassNodeTracker bc) {
        bc.declareInterface(DynamicStorage.class);
    }

    private void addFactoryMethod(ClassNodeTracker bc) {
        ClassNode classNode = bc.getClassNode();
        MethodNode method = new MethodNode(1, "newInstance", Type.getMethodDescriptor((Type)Type.getType(DynamicStorage.class), (Type[])new Type[0]), null, null);
        classNode.methods.add(method);
        InsnList instructions = method.instructions;
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, classNode.name));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, classNode.name, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
        instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    private void addFieldCount(ClassNodeTracker bc, int[] types, int objectCount) {
        ClassNode classNode = bc.getClassNode();
        MethodNode getFc = new MethodNode(1, "getFieldCount", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), null, null);
        classNode.methods.add(getFc);
        getFc.instructions.add(AsmHelper.getLoadConstantInsn(types.length));
        getFc.instructions.add((AbstractInsnNode)new InsnNode(172));
        MethodNode getOc = new MethodNode(1, "getObjectCount", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), null, null);
        classNode.methods.add(getOc);
        getOc.instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
        getOc.instructions.add((AbstractInsnNode)new InsnNode(172));
    }

    private void addInitialize(ClassNodeTracker bc, int objectCount) {
        ClassNode classNode = bc.getClassNode();
        MethodNode initMeth = new MethodNode(1, "initialize", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        classNode.methods.add(initMeth);
        InsnList instructions = initMeth.instructions;
        LabelNode lblEndIf = null;
        if (objectCount > 0) {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
            lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIf));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
            instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, "objects", Type.getDescriptor(Object[].class)));
        }
        if (lblEndIf != null) {
            instructions.add(lblEndIf);
        }
        instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private int declareFields(int[] types, ClassNodeTracker bc) {
        ClassNode classNode = bc.getClassNode();
        classNode.fields.add(new FieldNode(2, "objects", Type.getDescriptor(Object[].class), null, null));
        int objectCount = 0;
        for (int i = 0; i < types.length; ++i) {
            Class type = this.forType(types[i]);
            if (type == Object.class) {
                ++objectCount;
                continue;
            }
            classNode.fields.add(new FieldNode(2, this.getFieldName(i), Type.getDescriptor((Class)type), null, null));
        }
        return objectCount;
    }

    private void addSetMethods(ClassNodeTracker bc, int[] types, int totalObjects) {
        for (int type : TYPES) {
            this.addSetMethod(type, bc, types, totalObjects);
        }
    }

    private void addSetMethod(int typeCode, ClassNodeTracker bc, int[] types, int totalObjects) {
        int handle = this.getCreateFieldMethods(typeCode);
        if (handle == 1) {
            return;
        }
        Class type = this.forType(typeCode);
        Object name = Object.class.equals((Object)type) ? "Object" : StringUtil.capitalize(type.getName());
        name = "set" + (String)name;
        ClassNode classNode = bc.getClassNode();
        MethodNode method = new MethodNode(1, (String)name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType((Class)type)}), null, null);
        classNode.methods.add(method);
        InsnList instructions = method.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        LabelNode defLbl = new LabelNode();
        TableSwitchInsnNode switchNd = new TableSwitchInsnNode(0, types.length - 1, defLbl, new LabelNode[0]);
        instructions.add((AbstractInsnNode)switchNd);
        int objectCount = 0;
        for (int i = 0; i < types.length; ++i) {
            LabelNode caseLbl;
            if (!this.isCompatible(types[i], typeCode)) {
                caseLbl = new LabelNode();
                switchNd.labels.add(caseLbl);
                instructions.add((AbstractInsnNode)caseLbl);
                instructions.add(DynamicStorageGenerator.getDefaultSetInstructions(handle));
                continue;
            }
            caseLbl = new LabelNode();
            switchNd.labels.add(caseLbl);
            instructions.add((AbstractInsnNode)caseLbl);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (typeCode >= 8) {
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                LabelNode lblEndNonNull = new LabelNode();
                instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndNonNull));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add(AsmHelper.getLoadConstantInsn(totalObjects));
                instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
                instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                instructions.add((AbstractInsnNode)lblEndNonNull);
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.add((AbstractInsnNode)new InsnNode(83));
                ++objectCount;
            } else {
                instructions.add((AbstractInsnNode)new VarInsnNode(AsmHelper.getLoadInsn(type), 2));
                instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, "field" + i, Type.getInternalName((Class)type)));
            }
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        instructions.add((AbstractInsnNode)defLbl);
        instructions.add(DynamicStorageGenerator.getDefaultSetInstructions(handle));
    }

    private static InsnList getDefaultSetInstructions(int handle) {
        InsnList defaultInsns;
        if (handle == 2) {
            defaultInsns = new InsnList();
            defaultInsns.add((AbstractInsnNode)new InsnNode(177));
        } else {
            defaultInsns = AsmHelper.throwException(IllegalArgumentException.class);
        }
        return defaultInsns;
    }

    private void addGetMethods(ClassNodeTracker bc, int[] types) {
        for (int type : TYPES) {
            this.addGetMethod(type, bc, types);
        }
    }

    private void addGetMethod(int typeCode, ClassNodeTracker bc, int[] types) {
        int handle = this.getCreateFieldMethods(typeCode);
        if (handle == 1) {
            return;
        }
        Class type = this.forType(typeCode);
        String name = "get" + (Object.class.equals((Object)type) ? "Object" : StringUtil.capitalize(type.getName()));
        ClassNode classNode = bc.getClassNode();
        MethodNode meth = new MethodNode(1, name, Type.getMethodDescriptor((Type)Type.getType((Class)type), (Type[])new Type[]{Type.INT_TYPE}), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        LabelNode defLbl = new LabelNode();
        TableSwitchInsnNode switchNd = new TableSwitchInsnNode(0, types.length - 1, defLbl, new LabelNode[0]);
        instructions.add((AbstractInsnNode)switchNd);
        int objectCount = 0;
        for (int i = 0; i < types.length; ++i) {
            LabelNode caseLbl;
            if (!this.isCompatible(types[i], typeCode)) {
                caseLbl = new LabelNode();
                switchNd.labels.add(caseLbl);
                instructions.add((AbstractInsnNode)caseLbl);
                instructions.add(DynamicStorageGenerator.getDefaultGetInstructions(typeCode, handle));
                continue;
            }
            caseLbl = new LabelNode();
            switchNd.labels.add(caseLbl);
            instructions.add((AbstractInsnNode)caseLbl);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (typeCode >= 8) {
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                LabelNode lblEndNonNull = new LabelNode();
                instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndNonNull));
                instructions.add((AbstractInsnNode)new InsnNode(1));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                instructions.add((AbstractInsnNode)lblEndNonNull);
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
                instructions.add((AbstractInsnNode)new InsnNode(50));
                instructions.add((AbstractInsnNode)new InsnNode(176));
                ++objectCount;
                continue;
            }
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "field" + i, Type.getInternalName((Class)type)));
            instructions.add((AbstractInsnNode)new InsnNode(AsmHelper.getReturnInsn(type)));
        }
        instructions.add((AbstractInsnNode)defLbl);
        instructions.add(DynamicStorageGenerator.getDefaultGetInstructions(typeCode, handle));
    }

    private static InsnList getDefaultGetInstructions(int typeCode, int handle) {
        InsnList defaultInsns;
        if (typeCode == 8 && handle == 2) {
            defaultInsns = new InsnList();
            defaultInsns.add((AbstractInsnNode)new InsnNode(1));
            defaultInsns.add((AbstractInsnNode)new InsnNode(176));
        } else {
            defaultInsns = AsmHelper.throwException(IllegalArgumentException.class);
        }
        return defaultInsns;
    }

    protected FieldNode addBeanField(ClassNodeTracker bc, String name, Class type) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        ClassNode classNode = bc.getClassNode();
        FieldNode field = new FieldNode(this.getFieldAccess(), name, Type.getDescriptor((Class)type), null, null);
        classNode.fields.add(field);
        name = StringUtil.capitalize(name);
        String prefix = type == Boolean.TYPE ? "is" : "get";
        MethodNode meth = new MethodNode(1, prefix + name, Type.getMethodDescriptor((Type)Type.getType((Class)type), (Type[])new Type[0]), null, null);
        classNode.methods.add(meth);
        meth.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        meth.instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, field.name, Type.getDescriptor((Class)type)));
        meth.instructions.add((AbstractInsnNode)new InsnNode(AsmHelper.getReturnInsn(type)));
        MethodNode meth2 = new MethodNode(1, "set" + name, Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((Class)type)}), null, null);
        classNode.methods.add(meth2);
        meth2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        meth2.instructions.add((AbstractInsnNode)new VarInsnNode(AsmHelper.getLoadInsn(type), 1));
        meth2.instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, field.name, Type.getDescriptor((Class)type)));
        meth2.instructions.add((AbstractInsnNode)new InsnNode(177));
        return field;
    }

    protected boolean isCompatible(int fieldType, int storageType) {
        if (storageType == 8) {
            return fieldType >= 8;
        }
        return fieldType == storageType;
    }

    protected Class forType(int type) {
        switch (type) {
            case 0: {
                return Boolean.TYPE;
            }
            case 1: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Short.TYPE;
            }
            case 6: {
                return Long.TYPE;
            }
            case 4: {
                return Float.TYPE;
            }
            case 3: {
                return Double.TYPE;
            }
        }
        return Object.class;
    }

    protected Class getWrapper(int type) {
        return this.getWrapper(this.forType(type));
    }

    protected Class getWrapper(Class c) {
        for (Class[] wrapper : WRAPPERS) {
            if (!wrapper[0].equals(c)) continue;
            return wrapper[1];
        }
        return c;
    }
}

