/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncapsulatedContentInfoStream {
    protected int blockSize_ = 2048;
    protected InputStream contentData_;
    protected ObjectID contentType_;

    public void writeTo(OutputStream outputStream) throws CMSException, IOException {
        DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.contentType_.getName() + " \n");
        if (this.contentData_ != null) {
            stringBuffer.append("Content data supplied from input stream.");
        } else {
            stringBuffer.append("no content!");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CMSException {
        if (this.contentType_ == null) {
            throw new CMSException("Cannot create ASN.1 object of CMS EncapsulatedContentInfo. At least the content type must be set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent((ASN1Object)this.contentType_);
        if (this.contentData_ != null) {
            OCTET_STRING oCTET_STRING = this.blockSize_ > 0 ? new OCTET_STRING(this.contentData_, this.blockSize_) : new OCTET_STRING(this.contentData_);
            CON_SPEC cON_SPEC = new CON_SPEC(0, (ASN1Object)oCTET_STRING);
            cON_SPEC.setIndefiniteLength(true);
            sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        }
        return sEQUENCE;
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public boolean hasContent() {
        return this.contentData_ != null;
    }

    public ObjectID getContentType() {
        return this.contentType_;
    }

    public InputStream getContentInputStream() {
        return this.contentData_;
    }

    protected void decode(DerInputStream derInputStream) throws CMSParsingException, IOException {
        DerInputStream derInputStream2 = derInputStream.readSequence();
        this.contentType_ = derInputStream2.readObjectID();
        if (derInputStream2.nextTag() == -1) {
            this.contentData_ = null;
            return;
        }
        DerInputStream derInputStream3 = derInputStream2.readContextSpecific();
        if (derInputStream3.nextTag() == 4) {
            this.contentData_ = Utils.a(derInputStream3);
            return;
        }
        throw new CMSParsingException("Next tag no OCTET STRING!");
    }

    public EncapsulatedContentInfoStream(InputStream inputStream, ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.contentData_ = inputStream;
    }

    public EncapsulatedContentInfoStream(InputStream inputStream) throws CMSParsingException, IOException {
        this();
        if (inputStream instanceof DerInputStream) {
            this.decode((DerInputStream)inputStream);
            return;
        }
        this.decode(new DerInputStream(inputStream));
    }

    public EncapsulatedContentInfoStream(ObjectID objectID) {
        this();
        this.contentType_ = objectID;
        this.contentData_ = null;
    }

    protected EncapsulatedContentInfoStream() {
    }
}

