/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.utils.Util;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.Holder;
import iaik.x509.attr.IssuerSerial;
import iaik.x509.attr.V1Form;
import iaik.x509.attr.V2Form;
import java.util.Enumeration;

public class Role
extends AttributeValue {
    private GeneralName a;
    private GeneralNames b;
    public static final ObjectID oid = ObjectID.role;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append("roleAuthority: {\n");
            Util.printIndented(this.b.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}\n");
        }
        if (this.a != null) {
            stringBuffer.append("roleName: {\n");
            Util.printIndented(this.a.toString(), true, "    ", stringBuffer);
            stringBuffer.append("\n}");
        } else {
            stringBuffer.append("");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null) {
            throw new NullPointerException("roleName must not be null!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, this.b.toASN1Object(), true));
        }
        sEQUENCE.addComponent(new CON_SPEC(1, this.a.toASN1Object(), false));
        return sEQUENCE;
    }

    public GeneralNames setRoleAuthority(AttributeCertificate attributeCertificate) {
        AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
        if (attCertIssuer != null) {
            if (attCertIssuer.getVForm() == 1) {
                this.b = ((V1Form)attCertIssuer).getGeneralNames();
            } else {
                IssuerSerial issuerSerial;
                this.b = ((V2Form)attCertIssuer).getIssuerName();
                if (this.b == null && (issuerSerial = ((V2Form)attCertIssuer).getBaseCertificateID()) != null) {
                    this.b = issuerSerial.getIssuer();
                }
            }
        }
        return this.b;
    }

    public void setRoleAuthority(GeneralNames generalNames) {
        this.b = generalNames;
    }

    public boolean roleSpecifiedBy(AttributeCertificate attributeCertificate) {
        if (attributeCertificate == null) {
            throw new NullPointerException("roleSpecificationCertificate must not be null!");
        }
        boolean bl = false;
        Holder holder = attributeCertificate.getHolder();
        GeneralNames generalNames = holder.getEntityName();
        if (generalNames != null && generalNames.contains(this.a)) {
            if (this.b != null) {
                AttCertIssuer attCertIssuer = attributeCertificate.getIssuer();
                if (attCertIssuer != null) {
                    GeneralNames generalNames2 = null;
                    if (attCertIssuer.getVForm() == 1) {
                        generalNames2 = ((V1Form)attCertIssuer).getGeneralNames();
                        if (generalNames2 != null && Role.a(this.b, generalNames2)) {
                            bl = true;
                        }
                    } else {
                        IssuerSerial issuerSerial;
                        generalNames2 = ((V2Form)attCertIssuer).getIssuerName();
                        if (generalNames2 != null && Role.a(this.b, generalNames2)) {
                            bl = true;
                        }
                        if (!bl && (issuerSerial = ((V2Form)attCertIssuer).getBaseCertificateID()) != null && (generalNames2 = issuerSerial.getIssuer()) != null && Role.a(this.b, generalNames2)) {
                            bl = true;
                        }
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public GeneralName getRoleName() {
        return this.a;
    }

    public GeneralNames getRoleAuthority() {
        return this.b;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot parse null ASN1Object.");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type " + aSN1Object.getAsnType() + ". Expected SEQUENCE.");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1) {
            throw new CodingException("Invalid number of components: " + n2 + ". roleName must be present.");
        }
        if (n2 > 2) {
            throw new CodingException("Invalid number of components: " + n2 + ". Role can only hold up to 2 components.");
        }
        int n3 = 0;
        while (n3 < n2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n3);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException("Invalid ASN.1 type " + aSN1Object.getAsnType() + ". Expected CON SPEC.");
            }
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
            int n4 = cON_SPEC.getAsnType().getTag();
            switch (n4) {
                case 0: {
                    cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
                    this.b = new GeneralNames((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                case 1: {
                    this.a = new GeneralName((ASN1Object)cON_SPEC.getValue());
                    break;
                }
                default: {
                    throw new CodingException("Invalid tag " + n4 + ". Expected 0 or 1!");
                }
            }
            ++n3;
        }
    }

    private static boolean a(GeneralNames generalNames, GeneralNames generalNames2) {
        boolean bl = false;
        Enumeration enumeration = generalNames.getNames();
        while (enumeration.hasMoreElements()) {
            if (!generalNames2.contains((GeneralName)enumeration.nextElement())) continue;
            bl = true;
        }
        return bl;
    }

    public Role(GeneralName generalName) {
        if (generalName == null) {
            throw new NullPointerException("roleName must not be null!");
        }
        this.a = generalName;
    }

    public Role(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public Role() {
    }
}

