/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2005;

import finanze.IDTE.generale2005.ComuniProvincia;
import finanze.IDTE.generale2005.Util;

public class CF {
    public static String omocodice = "LMNPQRSTUV";
    int fieldCfCodiceRitorno = 0;

    public CF(String cf) {
        try {
            this.controlliGenerici(cf);
            return;
        }
        catch (Exception e) {
            this.setCfCodiceRitorno(3);
            return;
        }
    }

    public CF(String cf, String cognome, String nome, String anno, int mese, int giorno, String sesso) {
        String cf_cognome = "";
        String cf_nome = "";
        String vocali = "AEIOU";
        String consonanti = "BCDFGHJKLMNPQRSTVWXYZ";
        char[] primeVocaliCogn = new char[cognome.length()];
        char[] primeConsonantiCogn = new char[cognome.length()];
        char[] primeVocaliNome = new char[nome.length()];
        char[] primeConsonantiNome = new char[nome.length()];
        int ctrVoc = 0;
        int ctrCon = 0;
        String meseAna = "ABCDEHLMPRST";
        String annoAna = "";
        String giornoAna = "";
        try {
            this.controlliGenerici(cf);
            if (this.getCfCodiceRitorno() != 0) {
                return;
            }
            ctrVoc = 0;
            ctrCon = 0;
            char[] cognomechar = new char[cognome.length()];
            cognome.getChars(0, cognome.length(), cognomechar, 0);
            int i = 0;
            while (i < cognome.length()) {
                if (cognomechar[i] >= 'A' && cognomechar[i] <= 'Z') {
                    if (vocali.indexOf(cognome.charAt(i)) != -1) {
                        primeVocaliCogn[++ctrVoc - 1] = cognome.charAt(i);
                    } else {
                        primeConsonantiCogn[++ctrCon - 1] = cognome.charAt(i);
                    }
                }
                ++i;
            }
            if (ctrCon >= 3) {
                cf_cognome = String.valueOf(String.valueOf(primeConsonantiCogn[0])) + String.valueOf(primeConsonantiCogn[1]) + String.valueOf(primeConsonantiCogn[2]);
            }
            if (ctrCon == 2 && ctrVoc >= 1) {
                cf_cognome = String.valueOf(String.valueOf(primeConsonantiCogn[0])) + String.valueOf(primeConsonantiCogn[1]) + String.valueOf(primeVocaliCogn[0]);
            }
            if (ctrCon == 1 && ctrVoc >= 2) {
                cf_cognome = String.valueOf(String.valueOf(primeConsonantiCogn[0])) + String.valueOf(primeVocaliCogn[0]) + String.valueOf(primeVocaliCogn[1]);
            }
            if (ctrCon == 2 && ctrVoc == 0) {
                cf_cognome = String.valueOf(String.valueOf(primeConsonantiCogn[0])) + String.valueOf(primeConsonantiCogn[1]) + "X";
            }
            if (ctrCon == 1 && ctrVoc == 1) {
                cf_cognome = String.valueOf(String.valueOf(primeConsonantiCogn[0])) + String.valueOf(primeVocaliCogn[0]) + "X";
            }
            if (ctrCon == 0 && ctrVoc > 2) {
                cf_cognome = String.valueOf(String.valueOf(primeVocaliCogn[0])) + String.valueOf(primeVocaliCogn[1]) + String.valueOf(primeVocaliCogn[2]);
            }
            if (ctrCon == 0 && ctrVoc == 2) {
                cf_cognome = String.valueOf(String.valueOf(primeVocaliCogn[0])) + String.valueOf(primeVocaliCogn[1]) + "X";
            }
            if (!cf.substring(0, 3).equals(cf_cognome)) {
                this.setCfCodiceRitorno(5);
                return;
            }
            ctrVoc = 0;
            ctrCon = 0;
            char[] nomechar = new char[nome.length()];
            nome.getChars(0, nome.length(), nomechar, 0);
            int i2 = 0;
            while (i2 < nome.length()) {
                if (nomechar[i2] >= 'A' && nomechar[i2] <= 'Z') {
                    if (vocali.indexOf(nome.charAt(i2)) != -1) {
                        primeVocaliNome[++ctrVoc - 1] = nome.charAt(i2);
                    } else {
                        primeConsonantiNome[++ctrCon - 1] = nome.charAt(i2);
                    }
                }
                ++i2;
            }
            if (ctrCon >= 4) {
                cf_nome = String.valueOf(String.valueOf(primeConsonantiNome[0])) + String.valueOf(primeConsonantiNome[2]) + String.valueOf(primeConsonantiNome[3]);
            }
            if (ctrCon == 3) {
                cf_nome = String.valueOf(String.valueOf(primeConsonantiNome[0])) + String.valueOf(primeConsonantiNome[1]) + String.valueOf(primeConsonantiNome[2]);
            }
            if (ctrCon == 2 && ctrVoc >= 1) {
                cf_nome = String.valueOf(String.valueOf(primeConsonantiNome[0])) + String.valueOf(primeConsonantiNome[1]) + String.valueOf(primeVocaliNome[0]);
            }
            if (ctrCon == 1 && ctrVoc >= 2) {
                cf_nome = String.valueOf(String.valueOf(primeConsonantiNome[0])) + String.valueOf(primeVocaliNome[0]) + String.valueOf(primeVocaliNome[1]);
            }
            if (ctrCon == 1 && ctrVoc == 1) {
                cf_nome = String.valueOf(String.valueOf(primeConsonantiNome[0])) + String.valueOf(primeVocaliNome[0]) + "X";
            }
            if (ctrCon == 0 && ctrVoc == 2) {
                cf_nome = String.valueOf(String.valueOf(primeVocaliNome[0])) + String.valueOf(primeVocaliNome[1]) + "X";
            }
            if (ctrCon == 0 && ctrVoc > 2) {
                cf_nome = String.valueOf(String.valueOf(primeVocaliNome[0])) + String.valueOf(primeVocaliNome[1]) + String.valueOf(primeVocaliNome[2]);
            }
            if (!cf.substring(3, 6).equals(cf_nome)) {
                this.setCfCodiceRitorno(6);
                return;
            }
            if (anno.length() > 2) {
                anno = anno.substring(anno.length() - 2, anno.length());
            }
            annoAna = omocodice.indexOf(cf.substring(6, 7)) > -1 ? String.valueOf(omocodice.indexOf(cf.substring(6, 7))) : cf.substring(6, 7);
            annoAna = omocodice.indexOf(cf.substring(7, 8)) > -1 ? String.valueOf(annoAna) + String.valueOf(omocodice.indexOf(cf.substring(7, 8))) : String.valueOf(annoAna) + cf.substring(7, 8);
            if (!annoAna.equals(anno)) {
                this.setCfCodiceRitorno(7);
                return;
            }
            if (!String.valueOf(meseAna.charAt(mese - 1)).equals(cf.substring(8, 9))) {
                this.setCfCodiceRitorno(7);
                return;
            }
            if (sesso.equals("F")) {
                giorno += 40;
            }
            giornoAna = omocodice.indexOf(cf.substring(9, 10)) > -1 ? String.valueOf(omocodice.indexOf(cf.substring(9, 10))) : cf.substring(9, 10);
            giornoAna = omocodice.indexOf(cf.substring(10, 11)) > -1 ? String.valueOf(giornoAna) + String.valueOf(omocodice.indexOf(cf.substring(10, 11))) : String.valueOf(giornoAna) + cf.substring(10, 11);
            if (Integer.parseInt(giornoAna) != giorno) {
                this.setCfCodiceRitorno(7);
                return;
            }
            return;
        }
        catch (Exception e) {
            this.setCfCodiceRitorno(3);
            return;
        }
    }

    public CF(String cf, String cognome, String nome, String anno, int mese, int giorno, String sesso, String catastale) {
        this(cf, cognome, nome, anno, mese, giorno, sesso);
        boolean isProvCorretta = false;
        String codCatastale = "";
        if (this.getCfCodiceRitorno() != 0) {
            return;
        }
        codCatastale = CF.getCodiceCatastale(cf);
        if (codCatastale == null) {
            this.setCfCodiceRitorno(12);
            return;
        }
        if (codCatastale.equals(catastale)) {
            return;
        }
        this.setCfCodiceRitorno(12);
    }

    public CF(String cf, String cognome, String nome, String anno, int mese, int giorno, String sesso, String comune, String provincia) {
        this(cf, cognome, nome, anno, mese, giorno, sesso);
        boolean isProvCorretta = false;
        String codCatastale = "";
        if (this.getCfCodiceRitorno() != 0) {
            return;
        }
        if (cf.charAt(11) == 'Z') {
            this.setCfCodiceRitorno(9);
            return;
        }
        codCatastale = CF.getCodiceCatastale(cf);
        if (codCatastale == null) {
            this.setCfCodiceRitorno(12);
            return;
        }
        String[] comprov = ComuniProvincia.getComProvDaCodCat(codCatastale);
        if (comprov == null) {
            this.setCfCodiceRitorno(12);
            return;
        }
        String[] prov = ComuniProvincia.getProvDaCom(comprov[0]);
        int i = 0;
        while (i < prov.length) {
            if (prov[i].equals(provincia)) {
                isProvCorretta = true;
            }
            ++i;
        }
        if (isProvCorretta) {
            if (comprov[0].equals(comune)) {
                return;
            }
            this.setCfCodiceRitorno(10);
            return;
        }
        this.setCfCodiceRitorno(11);
    }

    public static int controlla(String cf) {
        if (cf.length() != 16) {
            return 2;
        }
        try {
            int val;
            char ch;
            int i = 0;
            while (i < 6) {
                ch = cf.charAt(i);
                if (ch < 'A' || ch > 'Z') {
                    return 4;
                }
                ++i;
            }
            if (CF.getAnnoInt(cf) == -1) {
                return 4;
            }
            if (CF.getMeseInt(cf) == -1) {
                return 4;
            }
            int gf = CF.getGiornoFiscaleInt(cf);
            if (gf < 1 || gf > 31 && gf < 41 || gf > 71) {
                return 4;
            }
            ch = cf.charAt(11);
            if ((ch < 'A' || ch > 'M') && ch != 'Z') {
                return 4;
            }
            int i2 = 0;
            while (i2 < 3) {
                ch = cf.charAt(12 + i2);
                if (!Character.isDigit(ch) && (val = omocodice.indexOf(ch)) == -1) {
                    return 4;
                }
                ++i2;
            }
            String cd = "BAKPLCQDREVOSFTGUHMINJWZYX";
            String cp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            String nd = "10   2 3 4   5 6 7 8 9";
            String np = "0123456789";
            int check = 0;
            int i3 = 0;
            while (i3 < 15) {
                ch = cf.charAt(i3);
                val = i3 % 2;
                switch (val) {
                    case 0: {
                        if (Character.isDigit(ch)) {
                            check += nd.indexOf(ch);
                            break;
                        }
                        check += cd.indexOf(ch);
                        break;
                    }
                    case 1: {
                        if (Character.isDigit(ch)) {
                            check += np.indexOf(ch);
                            break;
                        }
                        check += cp.indexOf(ch);
                        break;
                    }
                }
                ++i3;
            }
            if (check % 26 == cp.indexOf(cf.charAt(15))) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return 3;
        }
    }

    public void controlliGenerici(String cf) {
        String cd = "BAKPLCQDREVOSFTGUHMINJWZYX";
        String cp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String nd = "10   2 3 4   5 6 7 8 9";
        String np = "0123456789";
        try {
            int appoggio = 0;
            if (cf.length() != 16) {
                this.setCfCodiceRitorno(2);
                return;
            }
            String strut = "AAAAAANNANNC";
            char[] cfchar = new char[cf.length()];
            cf.getChars(0, cf.length(), cfchar, 0);
            int i = 0;
            while (i < strut.length()) {
                if (strut.charAt(i) == 'A' && (cfchar[i] < 'A' || cfchar[i] > 'Z')) {
                    this.setCfCodiceRitorno(4);
                    return;
                }
                if (strut.charAt(i) == 'N' && (cfchar[i] < '0' || cfchar[i] > '9')) {
                    this.setCfCodiceRitorno(4);
                    return;
                }
                if (strut.charAt(i) == 'C' && (cfchar[i] < 'A' || cfchar[i] > 'M') && cfchar[i] != 'Z') {
                    this.setCfCodiceRitorno(4);
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < 15) {
                String elem = cf.substring(i, i + 1);
                int resto = i % 2;
                switch (resto) {
                    case 0: {
                        if (!Character.isDigit(cf.charAt(i))) {
                            appoggio += cd.indexOf(elem);
                            break;
                        }
                        appoggio += nd.indexOf(elem);
                        break;
                    }
                    case 1: {
                        if (!Character.isDigit(cf.charAt(i))) {
                            appoggio += cp.indexOf(elem);
                            break;
                        }
                        appoggio += np.indexOf(elem);
                        break;
                    }
                }
                ++i;
            }
            String checkDigit = cf.substring(15, 16);
            if (appoggio % 26 == cp.indexOf(checkDigit)) {
                this.setCfCodiceRitorno(0);
            } else {
                this.setCfCodiceRitorno(1);
            }
            return;
        }
        catch (Exception e) {
            this.setCfCodiceRitorno(3);
            return;
        }
    }

    public static String getAnno(String cf) {
        int val = CF.getAnnoInt(cf);
        if (val > -1) {
            return Util.formNum(2, val);
        }
        return null;
    }

    public static int getAnnoInt(String cf) {
        int val = CF.getOmocodeDigit(cf.charAt(6));
        if (val <= -1) {
            return -1;
        }
        int annoInt = val * 10;
        val = CF.getOmocodeDigit(cf.charAt(7));
        if (val > -1) {
            return annoInt += val;
        }
        return -1;
    }

    public int getCfCodiceRitorno() {
        return this.fieldCfCodiceRitorno;
    }

    public static String getCittadinanza(String cf) {
        char val = cf.charAt(11);
        if (val != 'Z') {
            return "ITA";
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getCodiceCatastale(String cf) {
        char[] ccat = new char[4];
        ccat[0] = cf.charAt(11);
        int i = 0;
        while (i < 3) {
            char ch = cf.charAt(12 + i);
            if (!Character.isDigit(ch)) {
                int val = omocodice.indexOf(ch);
                if (val <= -1) return null;
                ccat[i + 1] = Character.forDigit(val, 10);
            } else {
                ccat[i + 1] = ch;
            }
            ++i;
        }
        return new String(ccat);
    }

    public static String getGiorno(String cf) {
        int val = CF.getGiornoInt(cf);
        if (val > -1) {
            return Util.formNum(2, val);
        }
        return null;
    }

    public static int getGiornoFiscaleInt(String cf) {
        int val = CF.getOmocodeDigit(cf.charAt(9));
        if (val <= -1) {
            return -1;
        }
        int giornoInt = val * 10;
        val = CF.getOmocodeDigit(cf.charAt(10));
        if (val > -1) {
            return giornoInt += val;
        }
        return -1;
    }

    public static int getGiornoInt(String cf) {
        int giornoInt = CF.getGiornoFiscaleInt(cf);
        if (giornoInt > 40) {
            giornoInt -= 40;
        }
        return giornoInt;
    }

    public static String getMese(String cf) {
        int val = CF.getMeseInt(cf);
        if (val > -1) {
            return Util.formNum(2, val);
        }
        return null;
    }

    public static int getMeseInt(String cf) {
        int val = "ABCDEHLMPRST".indexOf(cf.charAt(8));
        if (val > -1) {
            ++val;
        }
        return val;
    }

    private static int getOmocodeDigit(char ch) {
        if (!Character.isDigit(ch)) {
            return omocodice.indexOf(ch);
        }
        return Character.getNumericValue(ch);
    }

    public static String getSesso(String cf) {
        int val = CF.getOmocodeDigit(cf.charAt(9));
        if (val > -1) {
            if (val >= 4) {
                return "F";
            }
            return "M";
        }
        return null;
    }

    public void setCfCodiceRitorno(int cfCodiceRitorno) {
        this.fieldCfCodiceRitorno = cfCodiceRitorno;
    }
}

