/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.random.SecRandom;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.util.Vector;

public class KeyAndCertificate {
    PrivateKey a;
    X509Certificate[] b;

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        if (n2 == 1) {
            outputStream.write(this.a.getEncoded());
            int n3 = 0;
            while (n3 < this.b.length) {
                this.b[n3].writeTo(outputStream);
                ++n3;
            }
        } else {
            String string = Util.toPemString(this.a);
            outputStream.write(Util.toASCIIBytes(string));
            int n4 = 0;
            while (n4 < this.b.length) {
                string = Util.toPemString(this.b[n4]);
                outputStream.write(Util.toASCIIBytes(string));
                ++n4;
            }
        }
        outputStream.close();
    }

    public void saveTo(String string, int n2) throws IOException {
        this.writeTo(new FileOutputStream(string), n2);
    }

    public boolean isEncrypted() {
        return this.a instanceof EncryptedPrivateKeyInfo;
    }

    public PrivateKey getPrivateKey() {
        return this.a;
    }

    public X509Certificate[] getCertificateChain() {
        return this.b;
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, SecureRandom secureRandom) throws NoSuchAlgorithmException {
        if (this.isEncrypted()) {
            return;
        }
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(this.a);
        if (algorithmID == null) {
            algorithmID = AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC;
        }
        if (secureRandom == null) {
            secureRandom = SecRandom.getDefault();
        }
        encryptedPrivateKeyInfo.encrypt(cArray, algorithmID, secureRandom);
        this.a = encryptedPrivateKeyInfo;
    }

    public PrivateKey decrypt(char[] cArray) throws NoSuchAlgorithmException {
        if (this.isEncrypted()) {
            try {
                EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (EncryptedPrivateKeyInfo)this.a;
                this.a = encryptedPrivateKeyInfo.decrypt(cArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new ProviderException(generalSecurityException.toString());
            }
        }
        return this.a;
    }

    public KeyAndCertificate(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), true);
    }

    public KeyAndCertificate(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
        this.b = x509CertificateArray;
        this.a = privateKey;
    }

    public KeyAndCertificate(String string) throws IOException {
        this(new FileInputStream(string), true);
    }

    private KeyAndCertificate(InputStream inputStream, boolean bl) throws IOException {
        Cloneable cloneable;
        try {
            cloneable = new ASN1(inputStream).toASN1Object();
            this.a = ((ASN1Object)cloneable).countComponents() == 2 ? new EncryptedPrivateKeyInfo((ASN1Object)cloneable) : PrivateKeyInfo.getPrivateKey((ASN1Object)cloneable);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to decode private key: " + invalidKeyException.toString());
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to decode private key: " + codingException.toString());
        }
        cloneable = new Vector();
        try {
            while (inputStream.available() > 10) {
                ((Vector)cloneable).addElement(new X509Certificate(inputStream));
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to decode certificate: " + certificateException.toString());
        }
        this.b = new X509Certificate[((Vector)cloneable).size()];
        ((Vector)cloneable).copyInto(this.b);
        inputStream.close();
    }

    public KeyAndCertificate(InputStream inputStream) throws IOException {
        this(Util.readStream(inputStream));
    }
}

