/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.DebugCMS;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.EncodeListener;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.cms.CMSParsingException;
import iaik.cms.CMSRuntimeException;
import iaik.cms.CMSSignatureException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.CertificateNotFoundException;
import iaik.cms.CertificateSet;
import iaik.cms.ContentStream;
import iaik.cms.EncapsulatedContentInfoStream;
import iaik.cms.InvalidSignatureValueException;
import iaik.cms.RevocationInfoChoices;
import iaik.cms.SDSEncodeListener;
import iaik.cms.SecurityProvider;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.b;
import iaik.cms.g;
import iaik.cms.m;
import iaik.utils.EOFListener;
import iaik.utils.NotifyEOFInputStream;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttributeCertificate;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;

public class SignedDataStream
implements g,
EncodeListener,
EOFListener,
ContentStream {
    static /* synthetic */ Class b;
    static /* synthetic */ Class c;
    private SDSEncodeListener e;
    protected SecurityProvider securityProvider_;
    protected int blockSize_ = 2048;
    protected int mode_ = 1;
    protected InputStream inputStream_;
    protected DerInputStream thisObject_;
    protected Vector signerInfos_;
    protected RevocationInfoChoices crls_;
    protected CertificateSet certSet_;
    protected EncapsulatedContentInfoStream encapContentInfo_;
    protected ObjectID contentType_;
    b a = new b(this);
    protected int version_ = 1;
    public static final int EXPLICIT = 2;
    public static final int IMPLICIT = 1;
    private static boolean d = DebugCMS.getDebugMode() && d;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(n2), (OutputStream)outputStream);
            return;
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo((ASN1Object)this.toASN1Object(), (OutputStream)outputStream);
            return;
        }
        catch (CMSException cMSException) {
            throw new IOException(cMSException.toString());
        }
    }

    public void verify(PublicKey publicKey, int n2) throws CMSSignatureException {
        if (n2 < 0 || n2 >= this.signerInfos_.size()) {
            throw new CMSSignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        if (!signerInfo.verifySignature(publicKey)) {
            throw new InvalidSignatureValueException("Signature verification error: wrong signature value!", signerInfo.getSignerIdentifier());
        }
    }

    public SignerInfo verify(X509Certificate x509Certificate) throws CMSSignatureException {
        int n2 = this.getSignerInfoIndex(x509Certificate);
        if (n2 == -1) {
            throw new CMSSignatureException("Cannot do verification. No signer for this certificate!");
        }
        this.verify(x509Certificate.getPublicKey(), n2);
        return (SignerInfo)this.signerInfos_.elementAt(n2);
    }

    public X509Certificate verify(int n2) throws CMSSignatureException {
        if (n2 < 0 || n2 >= this.signerInfos_.size()) {
            throw new CMSSignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        CertificateIdentifier certificateIdentifier = signerInfo.getSignerIdentifier();
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = this.getCertificate(certificateIdentifier);
        }
        catch (Exception exception) {
            throw new CertificateNotFoundException("Certificate for verifying the signature not found!", certificateIdentifier);
        }
        this.verify(x509Certificate.getPublicKey(), n2);
        return x509Certificate;
    }

    public String toString(boolean bl) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version_ + "\n");
        AlgorithmID[] algorithmIDArray = this.a.a();
        if (algorithmIDArray.length > 0) {
            stringBuffer.append("DigestAlgorithms: ");
            n2 = 0;
            while (n2 < algorithmIDArray.length) {
                stringBuffer.append(String.valueOf(algorithmIDArray[n2].getName()) + ",");
                ++n2;
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("EncapsulatedContentInfo: {\n");
        if (this.encapContentInfo_ != null) {
            Utils.printIndented(this.encapContentInfo_.toString(bl), true, stringBuffer);
        }
        stringBuffer.append("\n}\n");
        if (this.certSet_ != null && !this.certSet_.isEmpty()) {
            stringBuffer.append(this.certSet_);
        }
        if (this.crls_ != null && !this.crls_.isEmpty()) {
            stringBuffer.append(this.crls_);
        }
        stringBuffer.append("SignerInfos: " + this.signerInfos_.size() + "\n");
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("SignerInfo " + n2 + ": {\n");
                Utils.printIndented(((SignerInfo)enumeration.nextElement()).toString(true), true, stringBuffer);
                stringBuffer.append("\n}\n");
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    protected ASN1Object toASN1Object(int n2) throws CMSException {
        if (n2 < 0) {
            n2 = this.blockSize_;
        }
        if (this.mode_ == 1) {
            try {
                this.inputStream_ = this.a.a(this.inputStream_, false);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        if (this.mode_ == 1 && this.inputStream_ != null) {
            this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.inputStream_, this.contentType_);
            this.encapContentInfo_.setBlockSize(n2);
        } else {
            this.encapContentInfo_ = new EncapsulatedContentInfoStream(this.contentType_);
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        try {
            sEQUENCE.addComponent((ASN1Object)new INTEGER(this.version_));
            sEQUENCE.addComponent(ASN.createSetOf((ASN1Type[])this.a.a()));
            sEQUENCE.addComponent(this.encapContentInfo_.toASN1Object());
            sEQUENCE.addEncodeListener((EncodeListener)this, 1, 2);
        }
        catch (CodingException codingException) {
            throw new CMSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() throws CMSException {
        return this.toASN1Object(-1);
    }

    public void setSignerInfos(SignerInfo[] signerInfoArray) throws NoSuchAlgorithmException {
        this.signerInfos_.removeAllElements();
        if (signerInfoArray != null) {
            int n2 = 0;
            while (n2 < signerInfoArray.length) {
                SignerInfo signerInfo = signerInfoArray[n2];
                if (signerInfo != null) {
                    this.addSignerInfo(signerInfoArray[n2]);
                }
                ++n2;
            }
        }
        this.b();
    }

    public void setSecurityProvider(SecurityProvider securityProvider) {
        this.securityProvider_ = securityProvider;
        if (this.signerInfos_ != null) {
            Object[] objectArray = Util.toArray((Vector)this.signerInfos_);
            int n2 = 0;
            while (n2 < objectArray.length) {
                SignerInfo signerInfo = (SignerInfo)objectArray[n2];
                if (signerInfo.getSecurityProvider() == null) {
                    signerInfo.setSecurityProvider(this.securityProvider_);
                }
                ++n2;
            }
        }
    }

    public void setSDSEncodeListener(SDSEncodeListener sDSEncodeListener) throws NoSuchAlgorithmException {
        this.e = sDSEncodeListener;
        if (sDSEncodeListener != null) {
            OutputStream outputStream;
            AlgorithmID[] algorithmIDArray = sDSEncodeListener.getDigestAlgorithms();
            if (algorithmIDArray != null) {
                boolean bl = false;
                int n2 = 0;
                while (n2 < algorithmIDArray.length) {
                    if (this.a.a(algorithmIDArray[n2])) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    this.inputStream_ = this.a.a(this.inputStream_, false);
                }
            }
            if ((outputStream = this.e.getOutputStream()) != null) {
                this.inputStream_ = new m(this.inputStream_, outputStream);
            }
        }
    }

    public void setRevocationInfoChoices(RevocationInfoChoices revocationInfoChoices) {
        if (revocationInfoChoices == null) {
            this.crls_.removeAllRevocationInfos();
        } else {
            this.crls_ = revocationInfoChoices;
        }
        this.b();
    }

    public void setMessageDigest(AlgorithmID algorithmID, byte[] byArray) throws NoSuchAlgorithmException {
        this.a.b(algorithmID, byArray);
    }

    public void setInputStream(InputStream inputStream) {
        try {
            this.inputStream_ = this.a.a(inputStream, true);
            return;
        }
        catch (Exception exception) {
            this.inputStream_ = inputStream;
            return;
        }
    }

    public void setCertificates(Certificate[] certificateArray) {
        if (certificateArray == null || certificateArray.length == 0) {
            this.certSet_.removeAllCertificates();
        } else {
            this.certSet_.setCertificates(certificateArray);
        }
        this.b();
    }

    public void setCertificateSet(CertificateSet certificateSet) {
        if (certificateSet == null) {
            this.certSet_.removeAllCertificates();
        } else {
            this.certSet_ = certificateSet;
        }
        this.b();
    }

    public void setCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray == null || x509CRLArray.length == 0) {
            this.crls_.removeAllRevocationInfos();
        } else {
            this.crls_.setRevocationInfos((CRL[])x509CRLArray);
        }
        this.b();
    }

    public void setBlockSize(int n2) {
        this.blockSize_ = n2;
    }

    public boolean removeSignerInfo(CertificateIdentifier certificateIdentifier) {
        boolean bl = false;
        if (certificateIdentifier != null) {
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier2 = signerInfo.getSignerIdentifier();
                if (!certificateIdentifier2.equals(certificateIdentifier)) continue;
                bl = this.signerInfos_.removeElement(signerInfo);
            }
            this.b();
        }
        return bl;
    }

    public void notifyEOF() throws IOException {
        try {
            while (this.thisObject_.nextIsContextSpecific()) {
                int n2 = this.thisObject_.readContextSpecific(17);
                switch (n2) {
                    case 0: {
                        this.certSet_ = new CertificateSet((InputStream)this.thisObject_);
                        break;
                    }
                    case 1: {
                        this.crls_ = new RevocationInfoChoices((InputStream)this.thisObject_);
                        break;
                    }
                    default: {
                        throw new CMSParsingException("Invalid implicit tag " + n2 + "!");
                    }
                }
            }
            this.signerInfos_ = Util.getVector((Object[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(b != null ? b : (b = SignedDataStream.a("iaik.cms.SignerInfo")))));
            Object[] objectArray = Util.toArray((Vector)this.signerInfos_);
            int n3 = 0;
            while (n3 < objectArray.length) {
                SignerInfo signerInfo = (SignerInfo)objectArray[n3];
                signerInfo.a(this);
                signerInfo.setSecurityProvider(this.securityProvider_);
                ++n3;
            }
            if (Utils.getIaikProviderVersion() >= 3.16) {
                this.thisObject_.readEOC();
                return;
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing Object! " + codingException.getMessage());
        }
        catch (CMSParsingException cMSParsingException) {
            throw new IOException("Error parsing Object! " + cMSParsingException.getMessage());
        }
    }

    public X509Certificate[] getX509Certificates() {
        return this.certSet_.getX509Certificates();
    }

    public int getVersion() {
        return this.version_;
    }

    public SignerInfo[] getSignerInfos() {
        Object[] objectArray = new SignerInfo[this.signerInfos_.size()];
        this.signerInfos_.copyInto(objectArray);
        return objectArray;
    }

    public int getSignerInfoIndex(X509Certificate x509Certificate) {
        Enumeration enumeration = this.signerInfos_.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
            CertificateIdentifier certificateIdentifier = signerInfo.getSignerIdentifier();
            if (certificateIdentifier.identifiesCert(x509Certificate)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public SignerInfo getSignerInfo(X509Certificate x509Certificate) {
        Enumeration enumeration = this.signerInfos_.elements();
        SignerInfo signerInfo = null;
        if (x509Certificate != null) {
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo2 = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier = signerInfo2.getSignerIdentifier();
                if (!certificateIdentifier.identifiesCert(x509Certificate)) continue;
                signerInfo = signerInfo2;
                break;
            }
        }
        return signerInfo;
    }

    public SignerInfo getSignerInfo(CertificateIdentifier certificateIdentifier) {
        Enumeration enumeration = this.signerInfos_.elements();
        SignerInfo signerInfo = null;
        if (certificateIdentifier != null) {
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo2 = (SignerInfo)enumeration.nextElement();
                CertificateIdentifier certificateIdentifier2 = signerInfo2.getSignerIdentifier();
                if (!certificateIdentifier2.equals(certificateIdentifier)) continue;
                signerInfo = signerInfo2;
                break;
            }
        }
        return signerInfo;
    }

    public byte[] getSignedDigest(int n2) throws CMSException {
        SignerInfo signerInfo = (SignerInfo)this.signerInfos_.elementAt(n2);
        if (signerInfo == null) {
            throw new ArrayIndexOutOfBoundsException("Wrong signerInfoIndex: " + n2);
        }
        return signerInfo.getSignedDigest();
    }

    public SecurityProvider getSecurityProvider() {
        return this.securityProvider_;
    }

    public RevocationInfoChoices getRevocationInfoChoices() {
        return this.crls_;
    }

    public int getMode() {
        return this.mode_;
    }

    public byte[] getMessageDigest(AlgorithmID algorithmID) throws CMSRuntimeException, NoSuchAlgorithmException {
        return this.a.c(algorithmID);
    }

    public InputStream getInputStream() {
        return this.inputStream_;
    }

    public ObjectID getEncapsulatedContentType() {
        return this.contentType_;
    }

    public AlgorithmID[] getDigestAlgorithms() {
        return this.a.a();
    }

    public ObjectID getContentType() {
        return ObjectID.cms_signedData;
    }

    public X509Certificate[] getCertificates(CertificateIdentifier certificateIdentifier) throws CMSException {
        X509Certificate[] x509CertificateArray;
        X509Certificate x509Certificate = this.getCertificate(certificateIdentifier);
        try {
            x509CertificateArray = Utils.a(x509Certificate, this.certSet_.getX509Certificates());
        }
        catch (CertificateException certificateException) {
            x509CertificateArray = new X509Certificate[]{x509Certificate};
        }
        return x509CertificateArray;
    }

    public Certificate[] getCertificates() {
        return this.certSet_.getCertificates();
    }

    public CertificateSet getCertificateSet() {
        return this.certSet_;
    }

    public X509Certificate getCertificate(CertificateIdentifier certificateIdentifier) throws CMSException {
        if (this.certSet_ == null) {
            throw new CMSException("Certificate not found!");
        }
        if (certificateIdentifier == null) {
            throw new NullPointerException("Cannot search certificate for null signerIdentifier!");
        }
        X509Certificate x509Certificate = this.certSet_.getX509Certificate(certificateIdentifier);
        if (x509Certificate == null) {
            throw new CMSException("Certificate not found!");
        }
        return x509Certificate;
    }

    public X509CRL[] getCRLs() {
        return this.crls_.getX509CRLs();
    }

    public int getBlockSize() {
        return this.blockSize_;
    }

    public AttributeCertificate[] getAttributeCertificates() {
        return this.certSet_.getAttributeCertificates();
    }

    public void encodeCalled(ASN1Object aSN1Object, int n2) throws CodingException {
        try {
            if (this.e != null) {
                this.e.beforeComputeSignature(this);
            }
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                ((SignerInfo)enumeration.nextElement()).a();
            }
            if (this.e != null) {
                this.e.afterComputeSignature(this);
            }
            if (this.certSet_ != null && !this.certSet_.isEmpty()) {
                aSN1Object.addComponent((ASN1Object)new CON_SPEC(0, this.certSet_.toASN1Object(), true));
            }
            if (this.crls_ != null && !this.crls_.isEmpty()) {
                aSN1Object.addComponent((ASN1Object)new CON_SPEC(1, this.crls_.toASN1Object(), true));
            }
            aSN1Object.addComponent(ASN.createSetOf((Vector)this.signerInfos_));
            return;
        }
        catch (CMSException cMSException) {
            throw new CodingException("Error encoding SignedData: " + cMSException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws CMSParsingException, IOException {
        DerInputStream derInputStream;
        int n2;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        if ((n2 = (derInputStream = ((DerInputStream)inputStream).readSequence()).nextTag()) == 6) {
            ObjectID objectID = derInputStream.readObjectID();
            if (!objectID.equals((Object)ObjectID.cms_signedData)) {
                throw new CMSParsingException("Content type not SignedData!");
            }
            this.thisObject_ = derInputStream.readContextSpecific().readSequence();
        } else {
            this.thisObject_ = derInputStream;
        }
        this.version_ = this.thisObject_.readInteger().intValue();
        try {
            this.a.a((AlgorithmID[])ASN.parseSequenceOf((ASN1Object)DerCoder.decode((InputStream)this.thisObject_), (Class)(c != null ? c : (c = SignedDataStream.a("iaik.asn1.structures.AlgorithmID")))));
        }
        catch (CodingException codingException) {
            throw new IOException("Error parsing digest algorithms: " + codingException.toString());
        }
        this.encapContentInfo_ = new EncapsulatedContentInfoStream((InputStream)this.thisObject_);
        this.contentType_ = this.encapContentInfo_.getContentType();
        if (!this.encapContentInfo_.hasContent()) {
            this.mode_ = 2;
            this.notifyEOF();
            return;
        }
        this.inputStream_ = this.encapContentInfo_.getContentInputStream();
        try {
            this.inputStream_ = this.a.a(this.inputStream_, true);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
        this.inputStream_ = new NotifyEOFInputStream(this.inputStream_);
        ((NotifyEOFInputStream)this.inputStream_).addEOFListener((EOFListener)this);
    }

    public void clearSignatures(boolean bl, boolean bl2) {
        Enumeration enumeration = this.signerInfos_.elements();
        while (enumeration.hasMoreElements()) {
            SignerInfo signerInfo = (SignerInfo)enumeration.nextElement();
            if (!bl && signerInfo.b()) continue;
            signerInfo.setSignatureValue(null);
            if (!bl2) continue;
            signerInfo.removeSignedAttribute(ObjectID.messageDigest);
        }
    }

    private void b() {
        this.version_ = 1;
        if (this.certSet_.containsOtherCertificates() || this.crls_.containsOtherRevocationInfos()) {
            this.version_ = 5;
            return;
        }
        int n2 = this.certSet_.getAttributeCertificateType();
        if (n2 == 1) {
            this.version_ = 3;
        } else if (n2 == 2) {
            this.version_ = 4;
        }
        if (this.version_ < 3) {
            Enumeration enumeration = this.signerInfos_.elements();
            while (enumeration.hasMoreElements()) {
                if (((SignerInfo)enumeration.nextElement()).getVersion() != 3) continue;
                this.version_ = 3;
                break;
            }
        }
        if (this.version_ < 3 && !this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public void addSignerInfo(SignerInfo signerInfo) throws NoSuchAlgorithmException {
        boolean bl;
        signerInfo.a(this);
        if (signerInfo.getSecurityProvider() == null) {
            signerInfo.setSecurityProvider(this.securityProvider_);
        }
        AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
        boolean bl2 = signerInfo.getSignatureValue() == null;
        boolean bl3 = bl = this.a.a(algorithmID, bl2) && bl2;
        if (this.mode_ == 2 && bl) {
            this.inputStream_ = this.a.a(this.inputStream_, false);
        }
        this.signerInfos_.addElement(signerInfo);
        if (this.version_ < 3 && signerInfo.getVersion() == 3) {
            this.version_ = 3;
        }
    }

    public void addCertificates(Certificate[] certificateArray) {
        if (certificateArray != null && certificateArray.length > 0) {
            this.certSet_.addCertificates(certificateArray);
            this.b();
        }
    }

    public void addCRLs(X509CRL[] x509CRLArray) {
        if (x509CRLArray != null && x509CRLArray.length > 0) {
            this.crls_.addRevocationInfos((CRL[])x509CRLArray);
            this.b();
        }
    }

    public SignedDataStream(InputStream inputStream, AlgorithmID[] algorithmIDArray, SecurityProvider securityProvider) throws IOException {
        this();
        this.securityProvider_ = securityProvider;
        this.inputStream_ = inputStream;
        this.mode_ = 2;
        this.a = new b(this, algorithmIDArray);
        try {
            this.inputStream_ = this.a.a(this.inputStream_, true);
            return;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
        }
    }

    public SignedDataStream(InputStream inputStream, AlgorithmID[] algorithmIDArray) throws IOException {
        this(inputStream, algorithmIDArray, null);
    }

    public SignedDataStream(InputStream inputStream, SecurityProvider securityProvider) throws IOException, CMSParsingException {
        this();
        this.securityProvider_ = securityProvider;
        this.decode(inputStream);
    }

    public SignedDataStream(InputStream inputStream, ObjectID objectID, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.contentType_ = objectID;
        this.inputStream_ = inputStream;
        this.mode_ = n2;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    public SignedDataStream(InputStream inputStream, int n2) {
        this();
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Illegal mode specification: " + n2 + "! Expected " + 1 + " (implicit) or " + 2 + " (explicit)");
        }
        this.contentType_ = ObjectID.cms_data;
        this.inputStream_ = inputStream;
        this.mode_ = n2;
    }

    public SignedDataStream(InputStream inputStream) throws IOException, CMSParsingException {
        this(inputStream, (SecurityProvider)null);
    }

    public SignedDataStream(ObjectID objectID) {
        this();
        this.mode_ = 2;
        this.contentType_ = objectID;
        if (!this.contentType_.equals((Object)ObjectID.cms_data)) {
            this.version_ = 3;
        }
    }

    protected SignedDataStream() {
        this.signerInfos_ = new Vector();
        this.certSet_ = new CertificateSet();
        this.crls_ = new RevocationInfoChoices();
    }
}

