/*
 * Decompiled with CFR 0.152.
 */
package iaik.cms;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SubjectKeyID;
import iaik.utils.InternalErrorException;
import iaik.x509.X509Certificate;

class a
implements CertificateIdentifier {
    private CertificateIdentifier a;

    public String toString() {
        return String.valueOf(this.getKeyIdTypeName()) + ": " + this.a.toString();
    }

    public ASN1Object toASN1Object() {
        boolean bl = true;
        ASN1Object aSN1Object = null;
        try {
            aSN1Object = this.a.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("Error encoding certificate identifier: " + codingException.getMessage(), (Exception)((Object)codingException));
        }
        if (this.a.getKeyIdType() == 0) {
            return aSN1Object;
        }
        return new CON_SPEC(0, aSN1Object, bl);
    }

    public boolean identifiesCert(X509Certificate x509Certificate) {
        return this.a.identifiesCert(x509Certificate);
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public String getKeyIdTypeName() {
        return this.a.getKeyIdTypeName();
    }

    public int getKeyIdType() {
        return this.a.getKeyIdType();
    }

    public CertificateIdentifier getCertificateIdentifier() {
        return this.a;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof a)) {
            return false;
        }
        a a2 = (a)object;
        if (this.getKeyIdType() != a2.getKeyIdType()) {
            return false;
        }
        return this.a.equals(a2.getCertificateIdentifier());
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            this.a = new IssuerAndSerialNumber(aSN1Object);
            if (this.a == null) {
                throw new CodingException("Missing IssuerAndSerialNumber!");
            }
        } else {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object;
            cON_SPEC.forceImplicitlyTagged(ASN.OCTET_STRING);
            this.a = new SubjectKeyID((ASN1Object)cON_SPEC.getValue());
            if (this.a == null) {
                throw new CodingException("Missing SubjectKeyIdentifier!");
            }
        }
    }

    public a(CertificateIdentifier certificateIdentifier) {
        if (certificateIdentifier.getKeyIdType() != 0 && certificateIdentifier.getKeyIdType() != 1) {
            throw new IllegalArgumentException("Only IssuerAndSerialNumber or SubjectKeyIdentifier are allowed!");
        }
        this.a = certificateIdentifier;
    }

    public a(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }
}

