/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.dom.NodeSortRecord;
import com.sun.org.apache.xalan.internal.xsltc.dom.NodeSortRecordFactory;
import com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.ref.DTMAxisIteratorBase;

public final class SortingIterator
extends DTMAxisIteratorBase {
    private static final int INIT_DATA_SIZE = 16;
    private DTMAxisIterator _source;
    private NodeSortRecordFactory _factory;
    private NodeSortRecord[] _data;
    private int _free = 0;
    private int _current;

    public SortingIterator(DTMAxisIterator dTMAxisIterator, NodeSortRecordFactory nodeSortRecordFactory) {
        this._source = dTMAxisIterator;
        this._factory = nodeSortRecordFactory;
    }

    @Override
    public int next() {
        return this._current < this._free ? this._data[this._current++].getNode() : -1;
    }

    @Override
    public DTMAxisIterator setStartNode(int n) {
        try {
            this._startNode = n;
            this._source.setStartNode(this._startNode);
            this._data = new NodeSortRecord[16];
            this._free = 0;
            while ((n = this._source.next()) != -1) {
                this.addRecord(this._factory.makeNodeSortRecord(n, this._free));
            }
            this.quicksort(0, this._free - 1);
            this._current = 0;
            return this;
        }
        catch (Exception exception) {
            return this;
        }
    }

    @Override
    public int getPosition() {
        return this._current == 0 ? 1 : this._current;
    }

    @Override
    public int getLast() {
        return this._free;
    }

    @Override
    public void setMark() {
        this._source.setMark();
        this._markedNode = this._current;
    }

    @Override
    public void gotoMark() {
        this._source.gotoMark();
        this._current = this._markedNode;
    }

    @Override
    public DTMAxisIterator cloneIterator() {
        try {
            SortingIterator sortingIterator = (SortingIterator)super.clone();
            sortingIterator._source = this._source.cloneIterator();
            sortingIterator._factory = this._factory;
            sortingIterator._data = this._data;
            sortingIterator._free = this._free;
            sortingIterator._current = this._current;
            sortingIterator.setRestartable(false);
            return sortingIterator.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", cloneNotSupportedException.toString());
            return null;
        }
    }

    private void addRecord(NodeSortRecord nodeSortRecord) {
        if (this._free == this._data.length) {
            NodeSortRecord[] nodeSortRecordArray = new NodeSortRecord[this._data.length * 2];
            System.arraycopy(this._data, 0, nodeSortRecordArray, 0, this._free);
            this._data = nodeSortRecordArray;
        }
        this._data[this._free++] = nodeSortRecord;
    }

    private void quicksort(int n, int n2) {
        while (n < n2) {
            int n3 = this.partition(n, n2);
            this.quicksort(n, n3);
            n = n3 + 1;
        }
    }

    private int partition(int n, int n2) {
        NodeSortRecord nodeSortRecord = this._data[n + n2 >>> 1];
        int n3 = n - 1;
        int n4 = n2 + 1;
        while (true) {
            if (nodeSortRecord.compareTo(this._data[--n4]) < 0) {
                continue;
            }
            while (nodeSortRecord.compareTo(this._data[++n3]) > 0) {
            }
            if (n3 >= n4) break;
            NodeSortRecord nodeSortRecord2 = this._data[n3];
            this._data[n3] = this._data[n4];
            this._data[n4] = nodeSortRecord2;
        }
        return n4;
    }
}

