/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.NativeThread;

class NativeThreadSet {
    private long[] elts;
    private int used = 0;
    private boolean waitingToEmpty;

    NativeThreadSet(int n) {
        this.elts = new long[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int add() {
        long l = NativeThread.current();
        if (l == -1L) {
            return -1;
        }
        NativeThreadSet nativeThreadSet = this;
        synchronized (nativeThreadSet) {
            int n;
            int n2 = 0;
            if (this.used >= this.elts.length) {
                n = this.elts.length;
                int n3 = n * 2;
                long[] lArray = new long[n3];
                System.arraycopy(this.elts, 0, lArray, 0, n);
                this.elts = lArray;
                n2 = n;
            }
            for (n = n2; n < this.elts.length; ++n) {
                if (this.elts[n] != 0L) continue;
                this.elts[n] = l;
                ++this.used;
                return n;
            }
            assert (false);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(int n) {
        if (n < 0) {
            return;
        }
        NativeThreadSet nativeThreadSet = this;
        synchronized (nativeThreadSet) {
            this.elts[n] = 0L;
            --this.used;
            if (this.used == 0 && this.waitingToEmpty) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalAndWait() {
        NativeThreadSet nativeThreadSet = this;
        synchronized (nativeThreadSet) {
            int n = this.used;
            for (long l : this.elts) {
                if (l == 0L) continue;
                NativeThread.signal(l);
                if (--n == 0) break;
            }
            this.waitingToEmpty = true;
            int n2 = 0;
            while (this.used > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    n2 = 1;
                }
            }
            if (n2 != 0) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

