/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc.keyinfo;

import iaik.security.ecc.ecdsa.ECPrivateKey;
import iaik.utils.Util;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import iaik.xml.crypto.enc.keyinfo.KANonceImpl;
import iaik.xml.crypto.enc.spec.DHKeyAgreementParameterSpec;
import iaik.xml.crypto.utils.Nodes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.EncryptionMethod;
import javax.xml.crypto.enc.XMLEncryptionException;
import javax.xml.crypto.enc.keyinfo.AgreementMethod;
import javax.xml.crypto.enc.spec.AgreementMethodParameterSpec;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AgreementMethodImpl
extends AlgorithmMethodImpl
implements AgreementMethod {
    static /* synthetic */ Class class$javax$xml$crypto$enc$spec$AgreementMethodParameterSpec;
    private PrivateKey privateKey_;
    protected DigestMethodImpl digestMethod_;
    protected KANonceImpl kaNonce_;
    protected KeyInfoImpl recipientKeyInfo_;
    protected KeyInfoImpl originiatorKeyInfo_;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && "KA-Nonce".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || node.getNodeType() == 1 && "OriginatorKeyInfo".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI()) || node.getNodeType() == 1 && "RecipientKeyInfo".equals(node.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(node.getNamespaceURI())) {
                DOMStructure dOMStructure = DOMStructure.getInstance(node, dOMCryptoContext);
                if (dOMStructure != null) {
                    this.putChildStructure(dOMStructure);
                }
            } else {
                arrayList.add(node);
            }
            ++n;
        }
        super.unmarshalStructures(Nodes.nodeList(arrayList), dOMCryptoContext);
    }

    private static char[] toHexChars(int n) {
        return new char[]{AgreementMethodImpl.getHexDigit(n >>> 4 & 0xF), AgreementMethodImpl.getHexDigit(n & 0xF)};
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey_ = privateKey;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        if (dOMStructure instanceof KANonceImpl) {
            this.kaNonce_ = (KANonceImpl)dOMStructure;
        } else if (dOMStructure instanceof KeyInfoImpl) {
            KeyInfoImpl keyInfoImpl = (KeyInfoImpl)dOMStructure;
            if ("OriginatorKeyInfo".equals(keyInfoImpl.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(keyInfoImpl.getNamespace())) {
                this.originiatorKeyInfo_ = keyInfoImpl;
            } else if ("RecipientKeyInfo".equals(keyInfoImpl.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(keyInfoImpl.getNamespace())) {
                this.recipientKeyInfo_ = keyInfoImpl;
            } else {
                super.putChildStructure(dOMStructure);
            }
        } else {
            super.putChildStructure(dOMStructure);
        }
    }

    public XMLStructure getRecipientKeyInfo() {
        return this.recipientKeyInfo_;
    }

    public XMLStructure getOriginatorKeyInfo() {
        return this.originiatorKeyInfo_;
    }

    public String getNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }

    public String getLocalName() {
        return "AgreementMethod";
    }

    public byte[] getKANonce() {
        return this.kaNonce_ != null ? this.kaNonce_.getValue() : null;
    }

    private static char getHexDigit(int n) {
        return (char)(n < 10 ? 48 + n : 65 + (n - 10));
    }

    protected List getChildStructures() {
        ArrayList<DOMStructure> arrayList = new ArrayList<DOMStructure>();
        if (this.kaNonce_ != null) {
            arrayList.add(this.kaNonce_);
        }
        if (this.digestMethod_ != null) {
            arrayList.add(this.digestMethod_);
        }
        if (this.originiatorKeyInfo_ != null) {
            arrayList.add(this.originiatorKeyInfo_);
        }
        if (this.recipientKeyInfo_ != null) {
            arrayList.add(this.recipientKeyInfo_);
        }
        return arrayList;
    }

    private static byte[] getBytesFromCounter(int n) {
        String string = new String(AgreementMethodImpl.toHexChars(n)).toUpperCase();
        return string.getBytes();
    }

    private static Integer getBitSizeFromURI(String string) {
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes128")) {
            return new Integer(128);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes192-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes192")) {
            return new Integer(192);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-aes256")) {
            return new Integer(256);
        }
        if (string.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc") || string.equals("http://www.w3.org/2001/04/xmlenc#kw-tripledes")) {
            return new Integer(192);
        }
        return null;
    }

    public SecretKey generateSecretKey(EncryptionMethod encryptionMethod, PublicKey publicKey) throws XMLEncryptionException {
        SecretKeySpec secretKeySpec = null;
        try {
            Integer n;
            byte[] byArray = null;
            if (this.privateKey_ == null) {
                throw new XMLEncryptionException("KeyAgreement has been called without private key!");
            }
            if (this.privateKey_ instanceof ECPrivateKey) {
                byArray = this.generateAgreedSecret(this.privateKey_, publicKey, "ECDH");
            } else if (this.privateKey_ instanceof DHPrivateKey) {
                byArray = this.generateAgreedSecret(this.privateKey_, publicKey, "DH");
            }
            String string = encryptionMethod.getAlgorithm();
            byte[] byArray2 = string.getBytes();
            int n2 = 1;
            byte[] byArray3 = this.getKANonce();
            if (encryptionMethod.getKeySize() != null) {
                n = encryptionMethod.getKeySize();
            } else if (AgreementMethodImpl.getBitSizeFromURI(string) != null) {
                n = AgreementMethodImpl.getBitSizeFromURI(string);
            } else {
                throw new XMLEncryptionException("No keySize found for the provided algorithm: " + string);
            }
            byte[] byArray4 = n.toString().getBytes();
            MessageDigest messageDigest = this.digestMethod_ != null ? MessageDigest.getInstance(this.digestMethod_.getAlgorithm()) : MessageDigest.getInstance("SHA-1");
            int n3 = messageDigest.getDigestLength();
            int n4 = n / 8;
            byte[] byArray5 = new byte[n4];
            int n5 = 0;
            while (n5 < n4) {
                byte[] byArray6 = AgreementMethodImpl.getBytesFromCounter(n2);
                messageDigest.update(byArray);
                messageDigest.update(byArray6);
                messageDigest.update(byArray2);
                if (byArray3 != null) {
                    messageDigest.update(byArray3);
                }
                messageDigest.update(byArray4);
                byte[] byArray7 = messageDigest.digest();
                int n6 = n5 >= n4 - n3 ? n4 - n5 : n3;
                System.arraycopy(byArray7, 0, byArray5, n5, n6);
                n5 += n3;
                ++n2;
                System.out.println("\nKM: " + Util.toString((byte[])byArray7));
            }
            System.out.println("\nFinal result: \n" + Util.toString((byte[])byArray5));
            secretKeySpec = new SecretKeySpec(byArray5, "AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        return secretKeySpec;
    }

    protected byte[] generateAgreedSecret(PrivateKey privateKey, PublicKey publicKey, String string) {
        byte[] byArray = null;
        try {
            KeyAgreement keyAgreement = KeyAgreement.getInstance(string);
            keyAgreement.init(privateKey);
            keyAgreement.doPhase(publicKey, true);
            byArray = keyAgreement.generateSecret();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
        }
        return byArray;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public AgreementMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.algorithm_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(class$javax$xml$crypto$enc$spec$AgreementMethodParameterSpec != null ? class$javax$xml$crypto$enc$spec$AgreementMethodParameterSpec : (class$javax$xml$crypto$enc$spec$AgreementMethodParameterSpec = AgreementMethodImpl.class$("javax.xml.crypto.enc.spec.AgreementMethodParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new MarshalException(invalidParameterSpecException);
            }
        }
    }

    public AgreementMethodImpl(String string, byte[] byArray, KeyInfoImpl keyInfoImpl, KeyInfoImpl keyInfoImpl2, AgreementMethodParameterSpec agreementMethodParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(string, null);
        this.originiatorKeyInfo_ = keyInfoImpl;
        if (this.originiatorKeyInfo_ != null) {
            this.originiatorKeyInfo_.setLocalname("OriginatorKeyInfo");
            this.originiatorKeyInfo_.setNamsepace("http://www.w3.org/2001/04/xmlenc#");
        }
        this.recipientKeyInfo_ = keyInfoImpl2;
        if (this.recipientKeyInfo_ != null) {
            this.recipientKeyInfo_.setLocalname("RecipientKeyInfo");
            this.recipientKeyInfo_.setNamsepace("http://www.w3.org/2001/04/xmlenc#");
        }
        if (byArray != null) {
            this.kaNonce_ = new KANonceImpl(byArray);
        }
        if (agreementMethodParameterSpec != null && agreementMethodParameterSpec instanceof DHKeyAgreementParameterSpec) {
            this.digestMethod_ = (DigestMethodImpl)((DHKeyAgreementParameterSpec)agreementMethodParameterSpec).getDigestMethod();
        }
    }
}

