/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.ui.JavaTrayIconController;
import com.sun.deploy.ui.WindowsJavaTrayIcon;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class JavaTrayIcon {
    private static JavaTrayIcon soleInstance;
    protected JavaTrayIconController controller;

    public static void install(JavaTrayIconController javaTrayIconController) {
        if (JavaTrayIcon.isSupported()) {
            if (soleInstance != null) {
                throw new IllegalStateException("Already installed");
            }
            WindowsJavaTrayIcon windowsJavaTrayIcon = new WindowsJavaTrayIcon(javaTrayIconController);
            if (JavaTrayIcon.isEnabled()) {
                ((JavaTrayIcon)windowsJavaTrayIcon).installImpl();
            }
            soleInstance = windowsJavaTrayIcon;
        }
    }

    public static void notifyConsoleClosed() {
        if (soleInstance != null) {
            soleInstance.notifyConsoleClosedImpl();
        }
    }

    protected JavaTrayIcon(JavaTrayIconController javaTrayIconController) {
        this.controller = javaTrayIconController;
    }

    protected static boolean isEnabled() {
        Config.get();
        return Config.getBooleanProperty("deployment.system.tray.icon");
    }

    protected abstract void installImpl();

    protected abstract void notifyConsoleClosedImpl();

    private static boolean isSupported() {
        String string = ((String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.name");
            }
        })).toLowerCase();
        return string.startsWith("windows");
    }
}

