/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.filesystemutil;

import it.sogei.rcp.filesystemutil.IFileSystemUtil;
import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.util.RCPException;
import it.sogei.rcp.util.RelativePath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileSystemUtil
implements IFileSystemUtil {
    public void createFile(IRelativePath path) throws IOException {
        String absolutePath = null;
        if (path.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        absolutePath = path.getAbsolutePath();
        File f = new File(absolutePath);
        File directoryFile = f.getParentFile();
        if (directoryFile.exists()) {
            boolean success;
            if (!directoryFile.canWrite()) {
                throw new IOException("Non \u00e8 possibile scrivere nella cartella specificata " + directoryFile + ". Verificare i permessi di scrittura nella cartella.");
            }
            if (!f.exists() && !(success = f.createNewFile())) {
                throw new IOException("Creazione del file non riuscita");
            }
        } else {
            directoryFile.mkdirs();
            f.createNewFile();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteFile(IRelativePath path) throws IOException {
        String absolutePath = null;
        if (path.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        absolutePath = path.getAbsolutePath();
        File f = new File(absolutePath);
        File directoryFile = f.getParentFile();
        if (!directoryFile.exists()) throw new IOException("La cartella specificata " + directoryFile + " non esiste. Verificare che il nome della cartella sia corretto.");
        if (!directoryFile.canRead()) {
            throw new IOException("Non \u00e8 possibile leggere nella cartella specificata " + directoryFile + ". Verificare i permessi di lettura nella cartella.");
        }
        if (!directoryFile.canWrite()) {
            throw new IOException("Non \u00e8 possibile scrivere nella cartella specificata " + directoryFile + ". Verificare i permessi di scrittura nella cartella.");
        }
        if (!f.exists()) throw new IOException("Il file " + f.getAbsolutePath() + " non esiste.");
        boolean success = f.delete();
        if (success) return;
        throw new IOException("Cancellazione del file non riuscita");
    }

    public void copyFile(IRelativePath sourcePath, IRelativePath destinationPath) throws IOException {
        int len;
        String saPath = null;
        if (sourcePath.getRelativePath() == null) {
            throw new IOException("Il sourcePath non \u00e8 relativo");
        }
        saPath = sourcePath.getAbsolutePath();
        if (destinationPath.getFileName() == null) {
            throw new IOException("Specificare il nome del file nel  destinationPath");
        }
        String daPath = null;
        if (destinationPath.getRelativePath() == null) {
            throw new IOException("Il destinationPath non \u00e8 relativo");
        }
        daPath = destinationPath.getAbsolutePath();
        File fin = new File(saPath);
        File fout = new File(daPath);
        if (!fin.exists()) {
            throw new IOException("il file specificato " + fin.getPath() + " non esiste.");
        }
        if (!fin.canRead()) {
            throw new IOException("Non \u00e8 possibile leggere dal file  " + fin.getPath() + ". Verificare i permessi di lettura del file.");
        }
        if (!fout.getParentFile().exists()) {
            fout.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(fin);
        FileOutputStream out = new FileOutputStream(fout);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void createFile(InputStream streamSource, IRelativePath pathFileDest, boolean overwrite) throws IOException, FileNotFoundException {
        File outputFile = new File(pathFileDest.getAbsolutePath());
        if (!outputFile.exists() || outputFile.exists() && overwrite) {
            int bytes_read;
            FileOutputStream out = new FileOutputStream(outputFile);
            byte[] buffer = new byte[4096];
            while ((bytes_read = streamSource.read(buffer)) != -1) {
                out.write(buffer, 0, bytes_read);
            }
            streamSource.close();
            out.close();
        }
    }

    public void moveFile(IRelativePath sourcePath, IRelativePath destinationPath, String fileName) throws IOException {
        boolean success;
        String saPath = null;
        if (sourcePath.getRelativePath() == null) {
            throw new IOException("Il sourcePath non \u00e8 relativo");
        }
        saPath = sourcePath.getAbsolutePath();
        if (sourcePath.getFileName() == null) {
            saPath = String.valueOf(saPath) + "\\" + fileName;
        }
        if (destinationPath.getFileName() != null) {
            throw new IOException("Non inserire il nome del file nel  destinationPath");
        }
        String daPath = null;
        if (destinationPath.getRelativePath() == null) {
            throw new IOException("Il destinationPath non \u00e8 relativo");
        }
        daPath = destinationPath.getAbsolutePath();
        File file = new File(saPath);
        if (!file.exists()) {
            throw new IOException("Il file specificato " + file.getPath() + " non esiste.");
        }
        File dir = new File(daPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(success = file.renameTo(new File(dir, fileName)))) {
            String message = "Spostamento del file non riuscito";
            throw new IOException(message);
        }
    }

    public void createFolder(IRelativePath path) throws IOException {
        boolean success = true;
        String absolutePath = null;
        if (path.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        absolutePath = path.getAbsolutePath();
        File f = new File(absolutePath);
        success = f.exists() ? true : f.mkdirs();
        if (!success) {
            String message = "Creazione della cartella non riuscita.";
            throw new IOException(message);
        }
    }

    public void deleteFolder(IRelativePath path, boolean forceDel) throws IOException {
        String absolutePath = null;
        if (path.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        absolutePath = path.getAbsolutePath();
        File dir = new File(absolutePath);
        File[] files = dir.listFiles();
        boolean success = false;
        if (dir.exists()) {
            if (!dir.canWrite()) {
                throw new IOException("Verificare i permessi di scrittura nella cartella specificata.");
            }
            if (forceDel) {
                int n = 0;
                while (n < files.length) {
                    File nextFile = files[n];
                    if (nextFile.isDirectory() && forceDel) {
                        try {
                            String folderName = nextFile.getName();
                            RelativePath nextPath = new RelativePath(String.valueOf(path.getRelativePath()) + "\\" + folderName);
                            this.deleteFolder((IRelativePath)nextPath, true);
                        }
                        catch (RCPException e) {
                            e.printStackTrace();
                        }
                    } else if (!nextFile.isDirectory() && forceDel) {
                        String fileName = nextFile.getName();
                        try {
                            RelativePath pathFile = new RelativePath(String.valueOf(path.getRelativePath()) + "\\" + fileName);
                            this.deleteFile((IRelativePath)pathFile);
                        }
                        catch (RCPException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n;
                }
                success = dir.delete();
                if (!success) {
                    throw new IOException("Cancellazione della cartella non riuscita");
                }
            } else if (!forceDel && files.length > 0) {
                throw new IOException("La cartella specificata contiene altri file. Per cancellare sia i file che lka cartella impostare a zero il flag.");
            }
        } else {
            throw new IOException("la cartella specificata" + path + " non esiste.");
        }
    }

    public void copyFolder(IRelativePath sourcePath, IRelativePath destinationPath) throws IOException {
        if (sourcePath.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        String srPath = sourcePath.getAbsolutePath();
        if (sourcePath.getRelativePath() == null) {
            throw new IOException("Il path non \u00e8 relativo");
        }
        String drPath = destinationPath.getAbsolutePath();
        File src = new File(srPath);
        File dst = new File(drPath);
        if (!src.exists()) {
            throw new IOException("La cartella sorgente non esiste.");
        }
        if (!src.canRead()) {
            throw new IOException("Impossibile accedere alla cartella: " + src.getAbsolutePath() + ". Controllare i permessi sul file.");
        }
        if (src.isDirectory()) {
            boolean success;
            if (!dst.exists() && !(success = dst.mkdir())) {
                throw new IOException("Impossibile creare la cartella di destinazione.");
            }
            File[] children = src.listFiles();
            int i = 0;
            while (i < children.length) {
                try {
                    String nextSrcName = children[i].getName();
                    RelativePath nextSrcPath = new RelativePath(String.valueOf(sourcePath.getRelativePath()) + "\\" + nextSrcName);
                    String nextDstName = children[i].getName();
                    RelativePath nextDstPath = new RelativePath(String.valueOf(destinationPath.getRelativePath()) + "\\" + nextDstName);
                    this.copyFolder((IRelativePath)nextSrcPath, (IRelativePath)nextDstPath);
                }
                catch (RCPException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            this.copyFile(sourcePath, destinationPath);
        }
    }

    public void moveFolder(IRelativePath sourcePath, IRelativePath destinationPath) throws IOException {
        this.copyFolder(sourcePath, destinationPath);
        this.deleteFolder(sourcePath, true);
    }

    public void importFile(IAbsolutePath sourcePath, IRelativePath destinationPath) throws IOException {
        int len;
        String saPath = sourcePath.getAbsolutePath();
        String drPath = destinationPath.getAbsolutePath();
        File fin = new File(saPath);
        File fout = new File(drPath);
        if (!fin.exists()) {
            throw new IOException("il file specificato " + fin.getPath() + " non esiste.");
        }
        if (!fin.canRead()) {
            throw new IOException("Non \u00e8 possibile leggere dal file  " + fin.getPath() + ". Verificare i permessi di lettura del file.");
        }
        if (!fout.getParentFile().exists()) {
            fout.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(saPath);
        FileOutputStream out = new FileOutputStream(drPath);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void exportFile(IRelativePath sourcePath, IAbsolutePath destinationPath) throws IOException {
        int len;
        String srPath = sourcePath.getAbsolutePath();
        String darPath = destinationPath.getAbsolutePath();
        File fin = new File(srPath);
        File fout = new File(darPath);
        if (!fin.exists()) {
            throw new IOException("il file specificato " + fin.getPath() + " non esiste.");
        }
        if (!fin.canRead()) {
            throw new IOException("Non \u00e8 possibile leggere dal file  " + fin.getPath() + ". Verificare i permessi di lettura del file.");
        }
        if (!fout.getParentFile().exists()) {
            fout.getParentFile().mkdirs();
        }
        FileInputStream in = new FileInputStream(srPath);
        FileOutputStream out = new FileOutputStream(darPath);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

